﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

using DocumentFormat.OpenXml;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Spreadsheet;
using OfficeOpenXml;
using Renci.SshNet;
using Renci.SshNet.Sftp;

/*
 * https://riptutorial.com/fr/epplus
 * https://epplussoftware.com/developers/licenseexception
 */
namespace ConsoleApp1
{
    class Program
    {
        private static string _chemin = "";
        private static string _description_tram = "";
        private static string _gtin_tram = "";
        private static string _boutique = "";

        static void Main(string[] args)
        {
            ExcelPackage.LicenseContext = LicenseContext.NonCommercial;

            /*
             * Variables
             */
            //Program._chemin = @"D:\developpement\asp.net\generateur-mondoshopping.fr\ConsoleApp1\";  //  Local
            Program._chemin = @"C:\generateur-mondoshopping.fr\ConsoleApp1\";  //  Prod

            Console.WriteLine("Version 2020-10-16");
            Console.WriteLine("---");
            Console.WriteLine("");

            /*
             * Nom boutique
             */
            while (Program._boutique == "")
            {
                Console.WriteLine("Pour quel boutique générer le flux ?");
                Console.WriteLine("Saisir 1 pour mondoshopping.fr");
                Console.WriteLine("Saisir 2 pour promodepot-boutique.com");

                switch (Console.ReadLine())
                {
                    case "1":
                        Program._boutique = "mondoshopping.fr";
                        break;
                    case "2":
                        Program._boutique = "promodepot-boutique.com";
                        break;
                    default:
                        Program._boutique = "";
                        break;
                }
            }


            /*
             * Supprimer ancien flux 
             * Copie du fichier structure
             */
            Console.WriteLine("=> Archivage Flux");
            switch (Program._boutique)
            {
                case "mondoshopping.fr":
                    //  Flux Kwanko
                    if (File.Exists(Program._chemin + @"OUT\flux-mondoshopping-fr.xlsx") == true)
                        File.Delete(Program._chemin + @"OUT\flux-mondoshopping-fr.xlsx");

                    if (File.Exists(Program._chemin + @"OUT\flux-mondoshopping-fr.csv") == true)
                        File.Delete(Program._chemin + @"OUT\flux-mondoshopping-fr.csv");

                    File.Copy(Program._chemin + "structure.xlsx", Program._chemin + @"OUT\flux-mondoshopping-fr.xlsx");

                    //  Flux FB
                    if (File.Exists(Program._chemin + @"OUT\flux-facebook-mondoshopping-fr.xlsx") == true)
                        File.Delete(Program._chemin + @"OUT\flux-facebook-mondoshopping-fr.xlsx");

                    File.Copy(Program._chemin + "structure-fb.xlsx", Program._chemin + @"OUT\flux-facebook-mondoshopping-fr.xlsx");

                    //  Flux Google
                    if (File.Exists(Program._chemin + @"OUT\flux-google-mondoshopping-fr.xlsx") == true)
                        File.Delete(Program._chemin + @"OUT\flux-google-mondoshopping-fr.xlsx");

                    File.Copy(Program._chemin + "structure-google.xlsx", Program._chemin + @"OUT\flux-google-mondoshopping-fr.xlsx");
                    break;
                case "promodepot-boutique.com":
                    //  Flux Kwanko
                    if (File.Exists(Program._chemin + @"OUT\flux-promodepot-boutique-com.xlsx") == true)
                        File.Delete(Program._chemin + @"OUT\flux-promodepot-boutique-com.xlsx");

                    if (File.Exists(Program._chemin + @"OUT\flux-promodepot-boutique-com.csv") == true)
                        File.Delete(Program._chemin + @"OUT\flux-promodepot-boutique-com.csv");

                    File.Copy(Program._chemin + "structure.xlsx", Program._chemin + @"OUT\flux-promodepot-boutique-com.xlsx");

                    //  Flux FB
                    if (File.Exists(Program._chemin + @"OUT\flux-facebook-promodepot-boutique-com.xlsx") == true)
                        File.Delete(Program._chemin + @"OUT\flux-facebook-promodepot-boutique-com.xlsx");

                    File.Copy(Program._chemin + "structure-fb.xlsx", Program._chemin + @"OUT\flux-facebook-promodepot-boutique-com.xlsx");

                    //  Flux Google
                    if (File.Exists(Program._chemin + @"OUT\flux-google-promodepot-boutique-com.xlsx") == true)
                        File.Delete(Program._chemin + @"OUT\flux-google-promodepot-boutique-com.xlsx");

                    File.Copy(Program._chemin + "structure-google.xlsx", Program._chemin + @"OUT\flux-google-promodepot-boutique-com.xlsx");
                    break;
            }



            /*
             * Ouverture fichier écriture
             */
            Console.WriteLine("");
            Console.WriteLine("=> Ouverture fichier écriture");
            FileInfo fi_ecriture = null;
            StreamWriter fichier = null;
            FileInfo fichier_fb = null;
            FileInfo fichier_google = null;
            Encoding utf8 = Encoding.UTF8;

            switch (Program._boutique)
            {
                case "mondoshopping.fr":
                    fi_ecriture = new FileInfo(Program._chemin + @"OUT\flux-mondoshopping-fr.xlsx");
                    fichier = new StreamWriter(Program._chemin + @"OUT\flux-mondoshopping-fr.csv");
                    fichier_fb = new FileInfo(Program._chemin + @"OUT\flux-facebook-mondoshopping-fr.xlsx");
                    fichier_google = new FileInfo(Program._chemin + @"OUT\flux-google-mondoshopping-fr.xlsx");
                    break;
                case "promodepot-boutique.com":
                    fi_ecriture = new FileInfo(Program._chemin + @"OUT\flux-promodepot-boutique-com.xlsx");
                    fichier = new StreamWriter(Program._chemin + @"OUT\flux-promodepot-boutique-com.csv");
                    fichier_fb = new FileInfo(Program._chemin + @"OUT\flux-facebook-promodepot-boutique-com.xlsx");
                    fichier_google = new FileInfo(Program._chemin + @"OUT\flux-google-promodepot-boutique-com.xlsx");
                    break;
            }

            string chaine_entete = "ID";
            chaine_entete += ";nom usuel du produit";
            chaine_entete += ";descriptif";
            chaine_entete += ";URL page produit";
            chaine_entete += ";URL image produit";
            chaine_entete += ";stock";
            chaine_entete += ";prix barré TTC du produit";
            chaine_entete += ";prix actuel TTC du produit";
            chaine_entete += ";marque";
            chaine_entete += ";EAN";
            chaine_entete += ";reference interne";
            chaine_entete += ";reference fabriquant";
            chaine_entete += ";indicateur de nouveaute";
            chaine_entete += ";Couleur";
            chaine_entete += ";categorie du produit";

            fichier.WriteLine(chaine_entete);

            ExcelPackage excelPackage_ecriture_fb = new ExcelPackage(fichier_fb);
            ExcelPackage excelPackage_ecriture_google = new ExcelPackage(fichier_google);

            ExcelWorksheet feuil_fb = excelPackage_ecriture_fb.Workbook.Worksheets["dpa_product_catalog_sample_feed"];
            ExcelWorksheet feuil_google = excelPackage_ecriture_google.Workbook.Worksheets["Feuil1"];

            using (ExcelPackage excelPackage_ecriture = new ExcelPackage(fi_ecriture))
            {
                int ligne_exriture = 2;

                ExcelWorksheet feuil_source = excelPackage_ecriture.Workbook.Worksheets["Feuil1"];


                /*
                 * Parcours du fichier source
                 */
                Console.WriteLine("");
                Console.WriteLine("=> Ouverture fichier export");

                FileInfo fi = new FileInfo(Program._chemin + @"IN\source.xlsx");
                using (ExcelPackage excelPackage = new ExcelPackage(fi))
                {
                    //Get a WorkSheet by index. Note that EPPlus indexes are base 1, not base 0!
                    ExcelWorksheet feuil_produits = excelPackage.Workbook.Worksheets["Products"];

                    int ligne = 2;
                    string couleur = "";
                    string gender = "";
                    string visuel = "";
                    string description = "";
                    string id = "";
                    string reference_propre = "";

                    string chaine_temp = "";

                    while (feuil_produits.Cells["A" + ligne].Value != null)
                    {
                        chaine_temp = "";

                        if (feuil_produits.Cells["G" + ligne].Value != null && feuil_produits.Cells["H" + ligne].Value != null)
                        {
                            if (feuil_produits.Cells["G" + ligne].Value.ToString().Trim() != "" && feuil_produits.Cells["H" + ligne].Value.ToString().Trim() != "")
                            {
                                reference_propre = netoyer_reference(feuil_produits.Cells["J" + ligne].Value.ToString().Trim());

                                Program._description_tram = "";
                                Program._gtin_tram = "";

                                //Program.recuperation_valeur_flux(reference_propre);
                                Program.recuperation_valeur_flux(feuil_produits.Cells["J" + ligne].Value.ToString().Trim());

                                Console.WriteLine(ligne + " -- ###" + feuil_produits.Cells["H" + ligne].Value.ToString().Trim() + "###");

                                //  Changement stockage visuel
                                if (id != feuil_produits.Cells["A" + ligne].Value.ToString().Trim())
                                {
                                    id = feuil_produits.Cells["A" + ligne].Value.ToString().Trim();
                                    visuel = feuil_produits.Cells["E" + ligne].Value.ToString().Trim();

                                    if (Program._description_tram == "")
                                        description = Program.traitement_description(feuil_produits.Cells["C" + ligne].Value.ToString().Trim(), feuil_produits.Cells["B" + ligne].Value.ToString().Trim());
                                    else
                                        description = Program._description_tram;
                                }

                                //  Recherche gender et couleur
                                couleur = "";
                                gender = "";

                                if (feuil_produits.Cells["M" + ligne].Value != null)
                                {
                                    switch (feuil_produits.Cells["M" + ligne].Value.ToString().Trim())
                                    {
                                        case "Color":
                                        case "Couleur":
                                            couleur = feuil_produits.Cells["N" + ligne].Value.ToString().Trim();
                                            break;
                                        case "Sexe":
                                            gender = feuil_produits.Cells["N" + ligne].Value.ToString().Trim();
                                            break;
                                    }
                                }

                                if (feuil_produits.Cells["O" + ligne].Value != null)
                                {
                                    switch (feuil_produits.Cells["O" + ligne].Value.ToString().Trim())
                                    {
                                        case "Color":
                                        case "Couleur":
                                            couleur = feuil_produits.Cells["P" + ligne].Value.ToString().Trim();
                                            break;
                                        case "Sexe":
                                            gender = feuil_produits.Cells["P" + ligne].Value.ToString().Trim();
                                            break;
                                    }
                                }

                                if (feuil_produits.Cells["Q" + ligne].Value != null)
                                {
                                    switch (feuil_produits.Cells["Q" + ligne].Value.ToString().Trim())
                                    {
                                        case "Color":
                                        case "Couleur":
                                            couleur = feuil_produits.Cells["R" + ligne].Value.ToString().Trim();
                                            break;
                                        case "Sexe":
                                            gender = feuil_produits.Cells["R" + ligne].Value.ToString().Trim();
                                            break;
                                    }
                                }


                                //  ID
                                feuil_source.Cells["A" + ligne_exriture].Value = feuil_produits.Cells["A" + ligne].Value.ToString().Trim();
                                chaine_temp = feuil_produits.Cells["A" + ligne].Value.ToString().Trim().Replace(";", ",").Replace("\n", " ").Replace("\r", " ");
                                //feuil_fb.Cells["A" + ligne_exriture].Value = feuil_produits.Cells["A" + ligne].Value.ToString().Trim();
                                //feuil_fb.Cells["A" + ligne_exriture].Value = reference_propre.Trim() + "--" + couleur + "--" + gender;
                                feuil_fb.Cells["A" + ligne_exriture].Value = feuil_produits.Cells["K" + ligne].Value.ToString().Trim();
                                feuil_google.Cells["A" + ligne_exriture].Value = feuil_produits.Cells["A" + ligne].Value.ToString().Trim();

                                //  Title
                                string title_temp = "";
                                feuil_source.Cells["B" + ligne_exriture].Value = feuil_produits.Cells["B" + ligne].Value.ToString().Trim();
                                chaine_temp += ";" + feuil_produits.Cells["B" + ligne].Value.ToString().Trim().Replace(";", ",").Replace(@"\n", " ").Replace(@"\r", " ");
                                feuil_fb.Cells["B" + ligne_exriture].Value = feuil_produits.Cells["B" + ligne].Value.ToString().Trim();
                                //feuil_google.Cells["B" + ligne_exriture].Value = feuil_produits.Cells["B" + ligne].Value.ToString().Trim();
                                title_temp = feuil_produits.Cells["B" + ligne].Value.ToString().Trim();
                                feuil_google.Cells["B" + ligne_exriture].Value = title_temp[0].ToString().ToUpper() + title_temp.Substring(1).ToLower();

                                //  description
                                feuil_source.Cells["C" + ligne_exriture].Value = description;
                                chaine_temp += ";" + description.Replace(";", ",").Replace(@"\r\n", " ").Replace(@"\n\r", " ").Replace(@"\n", " ").Replace(@"\r", " ");
                                string desc_temp = description.Replace(";", ",").Replace("\r\n", " ").Replace("\n\r", " ").Replace("\n", " ").Replace("\r", " ");
                                if (description.Length < 4999)
                                {
                                    feuil_google.Cells["C" + ligne_exriture].Value = desc_temp[0].ToString().ToUpper() + desc_temp.Substring(1).ToLower();
                                    feuil_fb.Cells["C" + ligne_exriture].Value = desc_temp[0].ToString().ToUpper() + desc_temp.Substring(1).ToLower();
                                }
                                else
                                {
                                    feuil_google.Cells["C" + ligne_exriture].Value = desc_temp[0].ToString().ToUpper() + desc_temp.Substring(1, 4998).ToLower();
                                    feuil_fb.Cells["C" + ligne_exriture].Value = desc_temp[0].ToString().ToUpper() + desc_temp.Substring(1, 4998).ToLower();
                                }
                                

                                //  link
                                if (feuil_produits.Cells["K" + ligne].Value != null)
                                {
                                    feuil_source.Cells["D" + ligne_exriture].Value = feuil_produits.Cells["D" + ligne].Value.ToString().Trim() + "?variant=" + feuil_produits.Cells["K" + ligne].Value.ToString().Trim();
                                    chaine_temp += ";" + feuil_produits.Cells["D" + ligne].Value.ToString().Trim() + "?variant=" + feuil_produits.Cells["K" + ligne].Value.ToString().Trim().Replace(";", ",").Replace("\n", " ").Replace("\r", " ");
                                    feuil_google.Cells["D" + ligne_exriture].Value = feuil_produits.Cells["D" + ligne].Value.ToString().Trim() + "?variant=" + feuil_produits.Cells["K" + ligne].Value.ToString().Trim();
                                    feuil_fb.Cells["F" + ligne_exriture].Value = feuil_produits.Cells["D" + ligne].Value.ToString().Trim() + "?variant=" + feuil_produits.Cells["K" + ligne].Value.ToString().Trim();
                                }
                                else
                                {
                                    feuil_source.Cells["D" + ligne_exriture].Value = feuil_produits.Cells["D" + ligne].Value.ToString().Trim();
                                    chaine_temp += ";" + feuil_produits.Cells["D" + ligne].Value.ToString().Trim().Replace(";", ",").Replace("\n", " ").Replace("\r", " ");
                                    feuil_google.Cells["D" + ligne_exriture].Value = feuil_produits.Cells["D" + ligne].Value.ToString().Trim();
                                    feuil_fb.Cells["F" + ligne_exriture].Value = feuil_produits.Cells["D" + ligne].Value.ToString().Trim();
                                }

                                //  image_link
                                if (feuil_produits.Cells["E" + ligne].Value != null)
                                {
                                    feuil_source.Cells["E" + ligne_exriture].Value = feuil_produits.Cells["E" + ligne].Value.ToString().Trim();
                                    chaine_temp += ";" + feuil_produits.Cells["E" + ligne].Value.ToString().Trim().Replace(";", ",").Replace("\n", " ").Replace("\r", " ");
                                    feuil_google.Cells["E" + ligne_exriture].Value = feuil_produits.Cells["E" + ligne].Value.ToString().Trim();
                                    feuil_fb.Cells["G" + ligne_exriture].Value = feuil_produits.Cells["E" + ligne].Value.ToString().Trim();
                                }
                                else
                                {
                                    feuil_source.Cells["E" + ligne_exriture].Value = visuel;
                                    chaine_temp += ";" + visuel.Replace(";", ",").Replace("\n", " ").Replace("\r", " ");
                                    feuil_google.Cells["E" + ligne_exriture].Value = visuel;
                                    feuil_fb.Cells["G" + ligne_exriture].Value = visuel;
                                }

                                //  availability
                                if (feuil_produits.Cells["F" + ligne].Value != null)
                                {
                                    if (int.Parse(feuil_produits.Cells["F" + ligne].Value.ToString().Trim()) > 0)
                                    {
                                        feuil_source.Cells["F" + ligne_exriture].Value = "in stock";
                                        chaine_temp += ";in stock";
                                        feuil_google.Cells["F" + ligne_exriture].Value = "in stock";
                                        feuil_fb.Cells["I" + ligne_exriture].Value = "in stock";
                                    }
                                    else
                                    {
                                        feuil_source.Cells["F" + ligne_exriture].Value = "out of stock";
                                        chaine_temp += ";out of stock";
                                        feuil_google.Cells["F" + ligne_exriture].Value = "out of stock";
                                        feuil_fb.Cells["I" + ligne_exriture].Value = "out of stock";
                                    }
                                }
                                else
                                {
                                    feuil_source.Cells["F" + ligne_exriture].Value = "out of stock";
                                    chaine_temp += ";out of stock";
                                    feuil_google.Cells["F" + ligne_exriture].Value = "out of stock";
                                    feuil_fb.Cells["I" + ligne_exriture].Value = "out of stock";
                                }

                                //  price
                                if (feuil_produits.Cells["G" + ligne].Value != null)
                                {
                                    feuil_source.Cells["G" + ligne_exriture].Value = feuil_produits.Cells["G" + ligne].Value.ToString().Trim().Replace(",", ".");
                                    chaine_temp += ";" + feuil_produits.Cells["G" + ligne].Value.ToString().Trim().Replace(",", ".").Replace(";", ",").Replace("\n", " ").Replace("\r", " ");
                                    feuil_google.Cells["G" + ligne_exriture].Value = feuil_produits.Cells["G" + ligne].Value.ToString().Trim().Replace(",", ".");
                                    feuil_fb.Cells["J" + ligne_exriture].Value = feuil_produits.Cells["G" + ligne].Value.ToString().Trim().Replace(",", ".");
                                }
                                else
                                {
                                    chaine_temp += ";0";
                                    feuil_google.Cells["G" + ligne_exriture].Value = "0";
                                    feuil_fb.Cells["J" + ligne_exriture].Value = "0";
                                }

                                //  sale_price
                                if (feuil_produits.Cells["H" + ligne].Value != null)
                                {
                                    feuil_source.Cells["H" + ligne_exriture].Value = feuil_produits.Cells["H" + ligne].Value.ToString().Trim().Replace(",", ".");
                                    chaine_temp += ";" + feuil_produits.Cells["H" + ligne].Value.ToString().Trim().Replace(",", ".").Replace(";", ",").Replace("\n", " ").Replace("\r", " ");
                                    feuil_google.Cells["H" + ligne_exriture].Value = feuil_produits.Cells["H" + ligne].Value.ToString().Trim().Replace(",", ".");
                                    feuil_fb.Cells["K" + ligne_exriture].Value = feuil_produits.Cells["H" + ligne].Value.ToString().Trim().Replace(",", ".");
                                }
                                else
                                {
                                    chaine_temp += ";0";
                                    feuil_google.Cells["H" + ligne_exriture].Value = "0";
                                    feuil_fb.Cells["K" + ligne_exriture].Value = "0";
                                }

                                //  brand
                                feuil_source.Cells["I" + ligne_exriture].Value = feuil_produits.Cells["I" + ligne].Value.ToString().Trim();
                                chaine_temp += ";" + feuil_produits.Cells["I" + ligne].Value.ToString().Trim().Replace(";", ",").Replace("\n", " ").Replace("\r", " ");
                                feuil_google.Cells["I" + ligne_exriture].Value = feuil_produits.Cells["I" + ligne].Value.ToString().Trim();
                                feuil_fb.Cells["M" + ligne_exriture].Value = feuil_produits.Cells["I" + ligne].Value.ToString().Trim();

                                //  gtin
                                if (Program._gtin_tram != "")
                                {
                                    string gtin = Program._gtin_tram.Trim();
                                    feuil_source.Cells["J" + ligne_exriture].Value = gtin;
                                    chaine_temp += ";" + feuil_produits.Cells["J" + ligne].Value.ToString().Trim().Replace(";", ",").Replace("\n", " ").Replace("\r", " ");
                                    feuil_google.Cells["J" + ligne_exriture].Value = gtin;
                                    feuil_fb.Cells["L" + ligne_exriture].Value = gtin;
                                }
                                else
                                {
                                    chaine_temp += ";";
                                    feuil_google.Cells["J" + ligne_exriture].Value = "";
                                    feuil_fb.Cells["L" + ligne_exriture].Value = "";
                                }

                                //  MPN
                                if (feuil_produits.Cells["J" + ligne].Value != null)
                                {
                                    feuil_source.Cells["K" + ligne_exriture].Value = reference_propre;
                                    chaine_temp += ";" + reference_propre.Replace(";", ",").Replace("\n", " ").Replace("\r", " ");
                                    if(reference_propre.Length > 69)
                                        feuil_google.Cells["k" + ligne_exriture].Value = reference_propre.Substring(0, 69);
                                    else
                                        feuil_google.Cells["k" + ligne_exriture].Value = reference_propre;
                                    feuil_fb.Cells["N" + ligne_exriture].Value = reference_propre;
                                }
                                else { 
                                    chaine_temp += ";";
                                    feuil_google.Cells["k" + ligne_exriture].Value = "";
                                    feuil_fb.Cells["N" + ligne_exriture].Value = "";
                                }

                                chaine_temp += ";";

                                //  condition
                                feuil_source.Cells["L" + ligne_exriture].Value = "new";
                                chaine_temp += ";new";
                                feuil_google.Cells["L" + ligne_exriture].Value = "new";
                                feuil_fb.Cells["H" + ligne_exriture].Value = "new";

                                //  couleur
                                feuil_source.Cells["M" + ligne_exriture].Value = couleur;
                                chaine_temp += ";" + couleur.Replace(";", ",").Replace("\n", " ").Replace("\r", " ");
                                feuil_google.Cells["M" + ligne_exriture].Value = couleur;
                                feuil_fb.Cells["Q" + ligne_exriture].Value = couleur;

                                //  gender
                                feuil_source.Cells["N" + ligne_exriture].Value = gender;
                                chaine_temp += ";" + gender.Replace(";", ",").Replace("\n", " ").Replace("\r", " ");
                                feuil_google.Cells["N" + ligne_exriture].Value = gender;
                                feuil_fb.Cells["P" + ligne_exriture].Value = gender;

                                //  size
                                feuil_fb.Cells["R" + ligne_exriture].Value = "";

                                //  item_group_id
                                feuil_fb.Cells["O" + ligne_exriture].Value = "";

                                ligne_exriture++;

                                byte[] utf = System.Text.Encoding.UTF8.GetBytes(chaine_temp);
                                fichier.WriteLine(utf8.GetString(utf));
                            }
                        }

                        ligne++;
                    }

                    //Get the content from cells A1 and B1 as string, in two different notations
                    //string valA1 = firstWorksheet.Cells["A1"].Value.ToString();
                    //string valB1 = firstWorksheet.Cells[1, 2].Value.ToString();




                    //}
                    Console.WriteLine("");
                    Console.WriteLine("=> Fermeture fichier export");

                    Console.WriteLine("");
                    Console.WriteLine("=> Sauvegarde fichier écriture");
                    //Save your file
                    excelPackage_ecriture.Save();
                }
            }

                excelPackage_ecriture_fb.Save();
                excelPackage_ecriture_google.Save();

                /*
                 * Fermeture fichier écriture
                 */
                Console.WriteLine("");
                Console.WriteLine("=> Fermeture fichier écriture");

                fichier.Close();

            /*
             * Envois en FTP
             */

            Console.WriteLine("");
            Console.WriteLine("=> Envois flux FTP");

            using (SftpClient sftp = new SftpClient(@"ftp.cluster020.hosting.ovh.net", 22, "isolatioko-fluxogg", "skhxq66uq5qJ"))
            {
                string fichier_xlsx = "";
                switch (Program._boutique)
                {
                    case "mondoshopping.fr":
                        fichier_xlsx = Program._chemin + @"OUT\flux-mondoshopping-fr.xlsx";
                        Console.WriteLine("=> " + Program._chemin + @"OUT\flux-mondoshopping-fr.xlsx");
                        break;
                    case "promodepot-boutique.com":
                        fichier_xlsx = Program._chemin + @"OUT\flux-promodepot-boutique-com.xlsx";
                        Console.WriteLine("=> " + Program._chemin + @"OUT\flux-promodepot-boutique-com.xlsx");
                        break;
                }

                sftp.Connect();

                //sftp.ChangeDirectory(@"DataExplorerInput/");

                using (FileStream fs = new FileStream(fichier_xlsx, FileMode.Open))
                {
                    sftp.BufferSize = 4 * 1024;
                    sftp.UploadFile(fs, Path.GetFileName(fichier_xlsx));
                }

                sftp.Disconnect();
            }

            using (SftpClient sftp = new SftpClient(@"ftp.cluster020.hosting.ovh.net", 22, "isolatioko-fluxogg", "skhxq66uq5qJ"))
            {
                string fichier_csv = "";
                switch (Program._boutique)
                {
                    case "mondoshopping.fr":
                        fichier_csv = Program._chemin + @"OUT\flux-mondoshopping-fr.csv";
                        Console.WriteLine("=> " + Program._chemin + @"OUT\flux-mondoshopping-fr.csv");
                        break;
                    case "promodepot-boutique.com":
                        fichier_csv = Program._chemin + @"OUT\flux-promodepot-boutique-com.csv";
                        Console.WriteLine("=> " + Program._chemin + @"OUT\flux-promodepot-boutique-com.csv");
                        break;
                }

                sftp.Connect();

                //sftp.ChangeDirectory(@"DataExplorerInput/");

                using (FileStream fs = new FileStream(fichier_csv, FileMode.Open))
                {
                    sftp.BufferSize = 4 * 1024;
                    sftp.UploadFile(fs, Path.GetFileName(fichier_csv));
                }

                sftp.Disconnect();
            }

            using (SftpClient sftp = new SftpClient(@"ftp.cluster020.hosting.ovh.net", 22, "isolatioko-fluxogg", "skhxq66uq5qJ"))
            {
                string fichier_xlsx = "";
                switch (Program._boutique)
                {
                    case "mondoshopping.fr":
                        fichier_xlsx = Program._chemin + @"OUT\flux-facebook-mondoshopping-fr.xlsx";
                        Console.WriteLine("=> " + Program._chemin + @"OUT\flux-facebook-mondoshopping-fr.xlsx");
                        break;
                    case "promodepot-boutique.com":
                        fichier_xlsx = Program._chemin + @"OUT\flux-facebook-promodepot-boutique-com.xlsx";
                        Console.WriteLine("=> " + Program._chemin + @"OUT\flux-facebook-promodepot-boutique-com.xlsx");
                        break;
                }

                sftp.Connect();

                //sftp.ChangeDirectory(@"DataExplorerInput/");

                using (FileStream fs = new FileStream(fichier_xlsx, FileMode.Open))
                {
                    sftp.BufferSize = 4 * 1024;
                    sftp.UploadFile(fs, Path.GetFileName(fichier_xlsx));
                }

                sftp.Disconnect();
            }

            using (SftpClient sftp = new SftpClient(@"ftp.cluster020.hosting.ovh.net", 22, "isolatioko-fluxogg", "skhxq66uq5qJ"))
            {
                string fichier_xlsx = "";
                switch (Program._boutique)
                {
                    case "mondoshopping.fr":
                        fichier_xlsx = Program._chemin + @"OUT\flux-google-mondoshopping-fr.xlsx";
                        Console.WriteLine("=> " + Program._chemin + @"OUT\flux-google-mondoshopping-fr.xlsx");
                        break;
                    case "promodepot-boutique.com":
                        fichier_xlsx = Program._chemin + @"OUT\flux-google-promodepot-boutique-com.xlsx";
                        Console.WriteLine("=> " + Program._chemin + @"OUT\flux-google-promodepot-boutique-com.xlsx");
                        break;
                }

                sftp.Connect();

                //sftp.ChangeDirectory(@"DataExplorerInput/");

                using (FileStream fs = new FileStream(fichier_xlsx, FileMode.Open))
                {
                    sftp.BufferSize = 4 * 1024;
                    sftp.UploadFile(fs, Path.GetFileName(fichier_xlsx));
                }

                sftp.Disconnect();
            }

            Console.WriteLine("");
            Console.WriteLine("=> Fin Envois flux FTP");
            

            Console.WriteLine("");
                Console.WriteLine("=> Fin de la génération");
                //Console.ReadLine();
            
        }

        /// <summary>
        /// Traite la description pour retourner une chaine épuré
        /// </summary>
        /// <param name="chaine"></param>
        /// <returns></returns>
        public static string traitement_description(string chaine, string alternative)
        {
            //Console.WriteLine(chaine);

            string description = chaine;

            int pos1;
            int pos2;
            while (description.IndexOf("<") != -1 && description.IndexOf(">") != -1)
            {
                pos1 = description.IndexOf("<");
                pos2 = description.IndexOf(">");
                description = description.Substring(0, pos1) + description.Substring(pos2 + 1);
            }

            description = description.Replace("&gt;", "");
            description = description.Replace("✅", "");
            description = description.Replace("➔", "");

            if (description.Trim().Length < 5)
                description = alternative;

            if (description.Length > 600)
                description = description.Substring(0, 600) + "...";

            return description.Trim();
        }

        /// <summary>
        /// Retourne la référence netoyer
        /// </summary>
        /// <param name="sku"></param>
        /// <returns></returns>
        public static string netoyer_reference(string sku)
        {
            sku = sku.ToString().Trim().Replace("#", "-").Replace(".", "-").Replace(":", "-").Replace(";", "-").Replace("/", "-").Replace("~", "-").Replace(" ", "-");
            return sku;

        }

        /// <summary>
        /// Récupération des valeur dans xle flux tran si existant
        /// </summary>
        /// <param name="sku"></param>
        public static void recuperation_valeur_flux(string sku)
        {
            FileInfo fi = new FileInfo(Program._chemin + @"TRAM\flux-tram.xlsx");
            using (ExcelPackage excelPackage = new ExcelPackage(fi))
            {
                //Get a WorkSheet by index. Note that EPPlus indexes are base 1, not base 0!
                ExcelWorksheet feuil_produits = excelPackage.Workbook.Worksheets["flux"];

                int ligne = 2;
                bool trouver = false;

                while (feuil_produits.Cells["A" + ligne].Value != null && trouver == false)
                {
                    if (sku == "14-691-Navy-5-4182")
                        Console.WriteLine("###" + Program.netoyer_reference(feuil_produits.Cells["A" + ligne].Value.ToString().Trim()) + "### == ###" + sku + "###");
                    //if (Program.netoyer_reference(feuil_produits.Cells["A" + ligne].Value.ToString().Trim()) == sku || (Program.netoyer_reference(feuil_produits.Cells["A" + ligne].Value.ToString().Trim()).Contains(sku)))
                    if (feuil_produits.Cells["A" + ligne].Value.ToString().Trim() == sku)
                    {
                        if(feuil_produits.Cells["B" + ligne].Value != null)
                            Program._description_tram = feuil_produits.Cells["B" + ligne].Value.ToString().Trim();

                        Program._gtin_tram = feuil_produits.Cells["C" + ligne].Value.ToString().Trim();

                        trouver = true;
                    }

                    ligne++;
                }
            }
        }
    }
}
